$ENGINE=VBScript


call view.insertGeometryLayer()
call view.geometry().setVisible(true)

call view.insertMeshLayer()
call view.mesh.showNodes(true)
call view.mesh.showActiveOnly(true)
call view.mesh().setVisible(true)

call view.insertAttributesLayer()
call view.attributes.visualiseNone("Mesh")
call view.insertAttributesLayer()
call view.attributes.setCrossSectionExag(100.0)
call view.attributes.setCrossSectionShrink("None")
call view.attributes.showSmoothEccentricity(true)
call view.attributes.showVolumesSolid(false)
call view.attributes.setDrawStyle("Geometric", "Arrows")
call view.attributes.visualiseAll("Geometric")
call view.insertAttributesLayer()
call view.attributes.visualiseNone("Material")
call view.insertAttributesLayer()
call view.attributes.setDrawStyle("Supports", "Arrows")
call view.attributes.visualiseAll("Supports")
call view.insertAttributesLayer()
call view.attributes.visualiseNone("Loading")
call view.insertAttributesLayer()
call view.attributes.visualiseNone("Local Coordinates")
call view.insertAttributesLayer()
call view.attributes.visualiseNone("Activate")
call view.insertAttributesLayer()
call view.attributes.visualiseNone("Deactivate")

call view.insertValuesLayer()
call view.values.setResults("Reaction", "FZ")
call view.values.setShowLabels(true, 3, "Arial;100;Default;NoItalic;NoUnderline;NoStrikeOut;0;")
call view.values.setDecimalPlaces(3)
call view.values.setShowOptions(true, true, 100.0)

set ExcelApp = CreateAutomationObject("Excel.Application")
          set Workbook = ExcelApp.WorkBooks.Add

RF = database.countResultsFiles()

If RF > 0 then

For r = 1 to RF

SheetName = "Reaction FZ, Results File " & r
set WorkSheet= WorkBook.WorkSheets.Add  
WorkSheet.Name = SheetName
set WorkSheet = Workbook.Sheets(SheetName) 

' Add all LCID headings in column 1
LC = database.countLoadsets("All", r)  
'   msgbox "no of loadcases " & LC
For i = 1 to LC
   WorkSheet.Cells(i+1,1).Value = "LCID" & i
Next 'i

' Add all PL headings in row 1
AllPL = database.getAttributes("Prescribed Load")
PL = Ubound(AllPL)+1
'    msgbox "no of prescribed loads " & PL
For j = 1 to PL
     WorkSheet.Cells(1, j+1).Value = "TPSDP " & j
Next 'j

' create a set, so we don't disturb the user's selection
set mySet = newObjectSet()

'looping loadcases with TDSP looped inside, obtaining FZ
For i = 1 to LC
      call db.flushScriptedResults()
      set loadset = database.getLoadset(i, r)
      call view.setActiveLoadset(loadset)

' workaround for bug (also prettily shows the user whats going on)
      call view.update()

      For j = 1 to PL
          PointSelected = 0 
          call mySet.add("Loading", "TPSDP " & j)
          PointSelected = mySet.count("Point")
          If PointSelected = 1 then
              NodeNum =  mySet.getObject("Point").GetNodes()(0).getID() 
              resFZ = mySet.getObject("Point").GetNodes()(0).getResults("Reaction", "FZ")
'             msgbox "LCID" & i & " TPSDP " & j & " Reaction FZ " & resFZ 
              WorkSheet.Cells(i+1, j+1).Value = resFZ
          Else 
'             do nothing
          End if
          call mySet.remove("All")
      next 'j
   next 'i

next 'r

set loadset = nothing
set mySet = nothing


' save Excel Workbook 
    Fname = database.getDBFilenameNoExtension()
    Filename = Fname & "_Reactions.xls"
    WorkBook.SaveAs(Filename)
    set textWindow = getTextWindow()
    textWindow.WriteLine("Excel Document " & Filename  & " created")
' quit Excel
    ExcelApp.Quit
    Set ExcelApp = Nothing
     message = msgbox("Exported to " &  Filename ,0,"Launch reactions")  

Set WshShell = CreateObject("WScript.Shell")
' Run an instance of Excel with the required spreadsheet. The appearance of
' the application window is left as default and the script continues execution
' without waiting for finishing of the execution of Excel (program closed by user)
WshShell.Run "Excel " & """" & Filename & """", ,False

Else
getTextWindow().writeLine("There is no results file loaded.  Please load some results before running this script.")  
     message = msgbox("An error is detected, please see text window" ,0,"Launch reactions") 
End if